# V0.0.2
$debug = $true

function logToFile {
  param (
    $content
  )
  $timeNow = Get-Date (Get-Date).ToUniversalTime() -UFormat '+%Y-%m-%dT%H:%M:%S:%s.000Z'
  Add-Content -Path $pwd\log.log "`n$timeNow`n$content"
}

if ($debug) {logToFile "############ script start"}
Write-Host "Port aendern?" -BackgroundColor blue
$inQueuePort = Read-Host "leer wenn nein (Port 1500), sonst Port Nummer"
if ($inQueuePort -ne "") {
  $baseUrl = -join('http://localhost:', $inQueuePort, '/fiskaltrust/json/v1/Sign')
} else {
  $baseUrl = 'http://localhost:1500/fiskaltrust/json/v1/Sign'
}
$cashboxID = Read-Host "CashboxID"
if ($cashboxID -eq "") {
  if ($debug) {logToFile "keine Cashboxid eingegeben -> exit"}
  Write-Host "CashboxID muss angegeben werden."
  timeout 20
  exit
}

if ($debug) {logToFile "$baseUrl - $cashboxID"}

# zero-receipt with TSE info von middleware abfragen
$timeMoment = Get-Date (Get-Date).ToUniversalTime() -UFormat '+%Y-%m-%dT%H:%M:%S.000Z'
$body = @"
{
    `"ftCashBoxID`": `"$cashboxID`",
    `"cbTerminalID`": `"1`",
    `"cbReceiptReference`": `"ZeroReceiptAfterFailure`",
    `"cbReceiptMoment`": `"$timeMoment`",
    `"cbChargeItems`": [],
    `"cbPayItems`": [],
    `"ftReceiptCase`": 4919338172275490818
}
"@
# die antwort sollte ein signature und ftStateData feld mit TSE info als json enthalten
$response = Invoke-RestMethod $baseUrl -Method 'POST' -ContentType "application/json" -Body $body
if ($debug) {logToFile $("response ZeroRec. w. TSEInfo `n" + ($response | ConvertTo-Json))}
# (($response | ConvertTo-Json) | ConvertFrom-Json) - response ist ein psobject, dieses muss in-json und dann wieder von-json in eine hastable konvertiert werden um vorhandene keys zu pruefen
if ((($response | ConvertTo-Json) | ConvertFrom-Json).ftStateData -eq $Null) {
  if ($debug) {logToFile "ftstatedata nicht in response -> exit"}
  Write-Host "Fehler beim abfragen der TSE Info, geht ein Bonissimo Nullbeleg?"
  timeout 60
  exit
}
else {
  # json decode funktioniert nicht mit json daten in json. Also "decodieren" wir von hand. (evtl. nacheinander convert-from json - 1. response dann 2. ftStateData)
  $ftStateData = $response.ftStateData -replace '\"', '"'
  if ($debug) {logToFile $("ftStateData:`n" + $ftStateData) }
  $ftStateData = $ftStateData | ConvertFrom-Json
  $openCases = $ftStateData.TseInfo.CurrentStartedTransactionNumbers

  Write-Host "####"
  Write-Host "Anzahl aktuell offener Transaktionen: " $ftStateData.TseInfo.CurrentNumberOfStartedTransactions
  Write-Host "####"
  Write-Host "CurrentNumberOfSignatures " $ftStateData.TseInfo.CurrentNumberOfSignatures
  Write-Host "MaxNumberOfSignatures     " $ftStateData.TseInfo.MaxNumberOfSignatures
  Write-Host "MaxLogMemorySize          " $ftStateData.TseInfo.MaxLogMemorySize
  Write-Host "CurrentLogMemorySize      " $ftStateData.TseInfo.CurrentLogMemorySize
  Write-Host "SerialNumberOctet         " $ftStateData.TseInfo.SerialNumberOctet
  Write-Host "###"
}

if ($openCases -eq $Null) {
  if ($debug) {logToFile "keine offenen Vorgaenge auf TSE -> exit"}
  Write-Host "keine offenen Vorgaenge auf TSE."
  timeout 60
  exit
}
else {
  Write-Host "offene Transaktionen:" $openCases
  timeout 30
  $openCases = @{"CurrentStartedTransactionNumbers" = $openCases}
  $openCases = $openCases | ConvertTo-Json -Compress
  $timeMoment = Get-Date (Get-Date).ToUniversalTime() -UFormat '+%Y-%m-%dT%H:%M:%S.000Z'
  $body = @{
    "ftCashBoxID" = $cashboxID
    "cbReceiptReference" = ""
    "cbChargeItems" = @()
    "cbPayItems" = @()
    "cbTerminalID" = "1"
    "cbReceiptMoment" = $timeMoment
    "ftReceiptCase" = 4919338172267102219
    "ftReceiptCaseData" = $openCases
  } | ConvertTo-Json
  if ($debug) {logToFile $("closeCases request Body:`n" + ($body))}
  $response = Invoke-RestMethod $baseUrl -Method 'POST' -ContentType "application/json" -Body $body
  if ($debug) {logToFile $("closeCases request response:`n" + ($response | ConvertTo-Json))}
  # Die middleware antwortet mit ftState "ready" was nicht eindeutig fuer erfolg ist.
  # Die signatur ist aber fuer einen "Belegabbruch". Wenn "Belegabbruch" in response = erfolgreich.
  if (select-string -pattern "AVBelegabbruch" -InputObject ($response | out-string )) {
    if ($debug) {logToFile "Offene Vorgaenge erfolgreich geschlossen -> exit"}
    Write-Host "Offene Vorgaenge erfolgreich geschlossen."
    timeout 60
    exit
  }
  # wenn cases die nicht existieren geschlossen werden sollen erzeugt das einen durch nullbeleg behebbaren TSE ausfall.
  # die signatur enthaellt dann "Kommunikation mit der technischen Sicherheitseinrichtung (TSE) fehlgeschlagen"
  elseif (select-string -pattern "fehlgeschlagen" -InputObject ($response | out-string )) {
    if ($debug) {logToFile "Fehler beim schliessen der offenen Vorgaenge -> exit"}
    Write-Host "Fehler beim schliessen der offenen Vorgaenge."
    timeout 60
    exit
  }
  else {
    if ($debug) {logToFile "unbekannte antwort der middleware -> exit"}
    Write-Host "Unbekannte Antwort der Middleware."
    timeout 60
    exit
  }
}



